//---------------------------------------------------------------
// Fichero:  solucion2.asy
// Objetivo: Mostrar la solución 2
// Fecha:    L.29.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(2,3), B=(-3,4), C=(-4,-1), D=(3,-4), F=(2,0);
pair G=(0,4), H=(-8,0), I=(0,-1), J=(10,5), K=(-9,4);
pair L=(-7,-3), M=(8,3), Q=(8,-2), R=(6,-4), T=(9,2);

// Dimensiones de los ejes
real Xmin = -10, Xmax = 10, Ymin = -5, Ymax = 5, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A"), A, N, 5pt+black);
dot(Label("B"), B, N, 5pt+black);
dot(Label("C"), C, S, 5pt+black);
dot(Label("D"), D, W, 5pt+black);
dot(Label("F"), F, N, 5pt+black);
dot(Label("G"), G, E, 5pt+black);
dot(Label("H"), H, N, 5pt+black);
dot(Label("I"), I, E, 5pt+black);
dot(Label("J"), J, W, 5pt+black);
dot(Label("K"), K, N, 5pt+black);
dot(Label("L"), L, S, 5pt+black);
dot(Label("M"), M, W, 5pt+black);
dot(Label("Q"), Q, S, 5pt+black);
dot(Label("R"), R, S, 5pt+black);
dot(Label("T"), T, E, 5pt+black);
