//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Mostrar el enunciado 1
// Fecha:    J.1.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Dimensiones de los ejes
real Xmin = -10, Xmax = 10, Ymin = -6, Ymax = 6, Extra = 0.2;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Definición de los puntos
pair A=(-9,2), B=(10,-4), C=(10,4), D=(-8,-1), F=(7,0);
pair G=(6,2), H=(7,-4), I=(5,-3), J=(0,-4), K=(1,3);
pair L=(-2,-5), M=(-6,-3), Q=(4,-1), R=(0,0), T=(-5,4);

// Grosor de las líneas
defaultpen(2);

// El eje de abscisas
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A"), A, NE, 5pt+black);
dot(Label("B"), B, SW, 5pt+black);
dot(Label("C"), C, NW, 5pt+black);
dot(Label("D"), D, SW, 5pt+black);
dot(Label("F"), F, SE, 5pt+black);
dot(Label("G"), G, NE, 5pt+black);
dot(Label("H"), H, NE, 5pt+black);
dot(Label("I"), I, SW, 5pt+black);
dot(Label("J"), J, SE, 5pt+black);
dot(Label("K"), K, NE, 5pt+black);
dot(Label("L"), L, SE, 5pt+black);
dot(Label("M"), M, SW, 5pt+black);
dot(Label("Q"), Q, NE, 5pt+black);
dot(Label("R"), R, SW, 5pt+black);
dot(Label("T"), T, SW, 5pt+black);
