//---------------------------------------------------------------
// Fichero:  ejes.asy
// Objetivo: Representar los ejes y el origen de coordenadas
// Fecha:    M.9.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El eje de abscisas
draw ((-2,0) -- (4,0));

// El eje de ordenadas
draw ((0,-2) -- (0,4));

// El origen de coordenadas
dot((0,0), 5bp+black);

// Los textos
label("Eje de abscisas", (2,-0.3), blue+fontsize(6pt));
label("Origen de", (2, 2.2), blue+fontsize(6pt));
label("coordenadas", (2, 1.8), blue+fontsize(6pt));
label(rotate(90)*"Eje de ordenadas", (-0.3, 2), blue+fontsize(6pt));

// La flecha que señala al origen
draw((2,1.5) -- (0.3, 0.3),blue, Arrow(4bp));
