//---------------------------------------------------------------
// Fichero:  ejemplo.asy
// Objetivo: Mostrar un ejemplo de coordenadas de un punto
// Fecha:    D.28.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Las líneas que indican abscisa y ordenada
pen Punteado = linetype(new real[] {2,2});
draw((4,0) -- (4,3), Punteado+gray);
draw((0,3) -- (4,3), Punteado+gray);

// Dimensiones de los ejes
real Xmin = -1, Xmax = 5, Ymin = -1, Ymax = 4, Extra = 0.2;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El origen de coordenadas
dot((0,0), 5bp+black);

// El punto de ejemplo
dot(Label("P=(4,3)"), (4,3), N, 5pt+black);

// El color para mostrar las coordenadas
pen ColorCoord = deepmagenta;

// Las flechas que señalan las coordenadas
real Separacion = -0.7;
draw((Separacion,0) -- (Separacion,3),
     ColorCoord, Arrows(HookHead,5bp), Bars(2mm));
draw((0,Separacion) -- (4,Separacion),
     ColorCoord, Arrows(HookHead,5bp), Bars(2mm));

// Los textos de las coordenadas
label("Abscisa: 4", (2,1.5*Separacion), ColorCoord+fontsize(8pt));
label(rotate(90)*"Ordenada: 3", (1.5*Separacion, 1.5),
      ColorCoord+fontsize(8pt));
