//---------------------------------------------------------------
// Fichero:  mesa.asy
// Objetivo: Representar una mesa de billar con trayectorias
// Fecha:    V.19.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Los colores de las trayectorias
pen C1 = pink;
pen C2 = lightmagenta;
pen C3 = mediummagenta;
pen C4 = magenta;
pen C5 = heavymagenta;
pen C6 = deepmagenta;

// Los colores de los puntos de rebote
pen R1 = lightgreen;
pen R2 = mediumgreen;
pen R3 = green;
pen R4 = heavygreen;
pen R5 = deepgreen;

// Las trayectorias
draw((0,0) -- (3,3), C1, MidArrow(size=2mm));
draw((3,3) -- (4,2), C2, MidArrow(size=2mm));
draw((4,2) -- (2,0), C3, MidArrow(size=2mm));
draw((2,0) -- (0,2), C4, MidArrow(size=2mm));
draw((0,2) -- (1,3), C5, MidArrow(size=2mm));
draw((1,3) -- (4,0), C6, MidArrow(size=2mm));

// La mesa de billar
draw(box((0,0), (4,3)));

// Los puntos de rebote
dot((3,3), R1); label("1", (3,3), fontsize(6pt));
dot((4,2), R2); label("2", (4,2), fontsize(6pt));
dot((2,0), R3); label("3", (2,0), fontsize(6pt));
dot((0,2), R4); label("4", (0,2), fontsize(6pt));
dot((1,3), R5); label("5", (1,3), fontsize(6pt));

// Los puntos de origen y final
dot((0,0), orange); label("A", (0,0), fontsize(5pt));
dot((4,0), orange); label("B", (4,0), fontsize(5pt));

// Las dimensiones
real Separacion = 0.4;
draw((0,-Separacion) -- (4,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((-Separacion,0) -- (-Separacion,3),
     blue, Arrows(HookHead,5bp), Bars(2mm));
label("4 m", (2,-2*Separacion), fontsize(10pt));
label("3 m", (-2.5*Separacion,1.5), fontsize(10pt));
