//---------------------------------------------------------------
// Fichero:  mesarepetida.asy
// Objetivo: Representar varias mesas de billar con trayectorias
// Fecha:    V.19.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(1);

// Los colores de las trayectorias
pen C1 = pink;
pen C2 = lightmagenta;
pen C3 = mediummagenta;
pen C4 = magenta;
pen C5 = heavymagenta;
pen C6 = deepmagenta;

// Los colores de los puntos de rebote
pen R1 = lightgreen;
pen R2 = mediumgreen;
pen R3 = green;
pen R4 = heavygreen;
pen R5 = deepgreen;

// Las trayectorias
draw((0,0) -- (3,3), C1, MidArrow(size=2mm));
draw((3,3) -- (4,4), C2, MidArrow(size=2mm));
draw((4,4) -- (6,6), C3, MidArrow(size=2mm));
draw((6,6) -- (8,8), C4, MidArrow(size=2mm));
draw((8,8) -- (9,9), C5, MidArrow(size=2mm));
draw((9,9) -- (12,12), C6, MidArrow(size=2mm));

// Las mesas de billar
for ( int i=0 ; i<3 ; ++i )
    {
    for ( int j=0 ; j<4 ; ++j )
        { draw(shift(4*i,3*j)*box((0,0), (4,3))); }
    }

// Los puntos de rebote
dot((3,3), R1); label("1", (3,3), fontsize(6pt));
dot((4,4), R2); label("2", (4,4), fontsize(6pt));
dot((6,6), R3); label("3", (6,6), fontsize(6pt));
dot((8,8), R4); label("4", (8,8), fontsize(6pt));
dot((9,9), R5); label("5", (9,9), fontsize(6pt));

// Los puntos de origen y final
dot((0,0), orange); label("A", (0,0), fontsize(5pt));
dot((12,12), orange); label("B", (12,12), fontsize(5pt));

// Las dimensiones
real Separacion = 0.4;
for ( int i=0 ; i<3 ; ++i )
    {
    draw((4*i,-Separacion) -- (4+4*i,-Separacion),
         blue, Arrows(HookHead,5bp), Bars(2mm));
    label("4 m", (2+4*i,-2*Separacion), fontsize(10pt));
    }
for ( int j=0 ; j<4 ; ++j )
    {
    draw((-Separacion,3*j) -- (-Separacion,3+3*j),
         blue, Arrows(HookHead,5bp), Bars(2mm));
    label("3 m", (-2.5*Separacion,1.5+3*j), fontsize(10pt));
    }
