//---------------------------------------------------------------
// Fichero:  CincoOctavos.asy
// Objetivo: Dibujar cinco octavos en un círculo
// Fecha:    S.13.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2cm);

// Grosor de las líneas
defaultpen(1);

// El sector marcado
path Sector = ((0,0) -- (1,0) -- arc((0,0),1,0,45) -- cycle);

// Dibujamos cinco sectores rotando
for ( int i=0 ; i<=4 ; ++i )
    { fill(rotate(45*i) * Sector, mediumgray); }

// Una circunferencia
draw(circle((0,0), 1), black);

// Definimos el diámetro horizontal
path Diametro = ((-1,0) -- (1,0));

// Dibujamos cuatro veces el diámetro, con rotaciones
for ( int i=0 ; i<=3 ; ++i )
    { draw(rotate(45*i) * Diametro); }
