//---------------------------------------------------------------
// Fichero:  SieteDecimos.asy
// Objetivo: Dibujar siete décimos en un rectángulo
// Fecha:    D.21.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// La longitud completa del rectángulo
real Longitud = 5;

// Los componentes de la fracción
int Numerador = 7;
int Denominador = 10;

// La anchura de cada rectángulo pequeño
real Anchura = Longitud / Denominador;

// Los rectángulos marcados
fill (box ((0,0),(Anchura*Numerador,1)), mediumgray);

// El rectángulo individual
path Rectangulo = box ((0,0),(Anchura,1));

// El rectángulo grande
for ( int i=0; i<Denominador; ++i )
    { draw(shift(i*Anchura, 0) * Rectangulo); }
