//---------------------------------------------------------------
// Fichero:  enunciado3.asy
// Objetivo: Representar el esquema del enunciado 3
// Fecha:    M.9.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Para los caracteres no ASCII
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulo que marca el numerador
filldraw(box((0,0),(5,3)), mediumgray);

// El rectángulo que marca el total
draw(box((0,0), (7,3)));

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas
draw((0,-Separacion) -- (5,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((0,3+Separacion) -- (7,3+Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Las etiquetas
label("¿Total?", (3.5,3+3*Separacion), fontsize(16pt));
label("$\frac{7}{9}$", (2.5,1.5), fontsize(20pt));
label("196", (2.5,-3*Separacion), fontsize(16pt));
