//---------------------------------------------------------------
// Fichero:  enunciado03.asy
// Objetivo: Representar el enunciado 3
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Los extremos de las rectas
pair R1=PuntoCir(14), R2=-R1;
pair S1=PuntoCir(-14), S2=-S1;
pair T=(0,-0.5);

// El vértice
pair V=(0,0);

// Los ángulos
markangle("$\alpha$", radius=4mm, T, V, S1, 0.5bp+blue);
markangle("$\alpha$", radius=6mm, R2, V, T, 0.5bp+blue);
markangle("$152^\circ$", radius=5mm, R1, V, S2, 0.5bp+blue);

// Dibujamos las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(V -- T);
