//---------------------------------------------------------------
// Fichero:  enunciado14.asy
// Objetivo: Representar el enunciado 14
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Los extremos de las rectas
pair R1=0.3*PuntoCir(44), R2=-1.6*R1;
pair S1=0.4*PuntoCir(145), S2=-1.4*S1;
pair T1=(0.5,0), T2=(-0.5,0);
pair U1=(0.5,-0.3), U2=(-0.5,-0.3);

// Los vértices
pair V1=(0,0);
pair V2=intersectionpoint(U1 -- U2, R1 -- R2);

// Los ángulos
markangle("$\alpha$", radius=4mm, T1, V1, S1, 0.5bp+blue);
markangle("$81^\circ$", radius=3mm, R2, V1, S2, 0.5bp+blue);
markangle("$44^\circ$", radius=3mm, U1, V2, V1, 0.5bp+blue);

// Dibujamos las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T1 -- T2);
draw(U1 -- U2);
