//---------------------------------------------------------------
// Fichero:  angulo.asy
// Objetivo: Representar un ángulo
// Fecha:    X.21.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Los extremos de los lados
pair L1 = (1.2,1.2);
pair L2 = (1.2,-1.2);

// El sector relleno
pair M1=(1,1), M2=(1,-1), Final=(1,0);
pen ColorInicial=gray, ColorFinal=palegray;
path Sector = buildcycle(arc(V,M2,M1), M1 -- V -- M2);
axialshade(Sector, ColorInicial, V, ColorFinal, Final);

// Dibujamos los lados
draw(V -- L1);
draw(V -- L2);

// Marcamos el vértice
dot(V, 4bp+black);
