//---------------------------------------------------------------
// Fichero:  otrosnombres.asy
// Objetivo: Representar un ángulos con otros nombres
// Fecha:    X.21.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Los extremos de los lados
pair L1 = (1,0.3);
pair L2 = (-1,0.3);

// El ángulo
markangle(radius=5mm, L1, V, L2, 0.5bp+black);

// Dibujamos los lados
draw(V -- L1);
draw(V -- L2);

// Marcamos el vértice
dot("V", V, S, 4bp+black);

// Marcamos un punto en cada lado
dot("A", V+0.8*(L1-V), S, 4bp+black);
dot("B", V+0.8*(L2-V), S, 4bp+black);
