//---------------------------------------------------------------
// Fichero:  enunciado4.asy
// Objetivo: Enunciado 4
// Fecha:    M.6.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P1-V)-degrees(P2-V))+360*e)+"$^\circ$"; }

// El centro de la circunferencia
pair T=(0,0);
dot(T, 3bp+black);

// Vértice y extremos
pair V=(Cos(175),Sin(175)), A=(Cos(59),Sin(59)), B=(Cos(-37),Sin(-37));

// Los ángulos
markangle(Ang(A,T,B,1), radius=5mm, B, T, A, blue);
markangle("$2\alpha$", radius=10mm, V, A, T, blue);
markangle("$\alpha$", radius=20mm, T, B, V, blue);

// La circunferencia
draw(circle(T,1));

// Los ángulos
draw(A -- V -- B);
draw(A -- T -- B);
