//---------------------------------------------------------------
// Fichero:  ovejas.asy
// Objetivo: Ilustrar el problema de las ovejas
// Fecha:    V.9.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El triángulo
path Triangulo = polygon(3);
filldraw(Triangulo,mediumgray);

// Los tres sectores
real Radio=sqrt(3)/2;
for ( int i=0 ; i<3 ; ++i )
    {
    pair Ver = point(Triangulo,i);
    pair Sig = (Ver+point(Triangulo,i+1))/2;
    pair Ant = (Ver+point(Triangulo,i-1))/2;
    filldraw(Ver -- Sig -- arc(Ver,Sig,Ant) -- cycle, white, black);
    }
