//---------------------------------------------------------------
// Fichero:  segmento2.asy
// Objetivo: Representar otro segmento circular
// Fecha:    J.1.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// El centro de la circunferencia
pair T=(0,0);

// Extremos de la cuerda
pair A=(1,0), B=(Cos(150),Sin(150));

// Punto medio de la cuerda
pair M=(A+B)/2;

// La circunferencia
draw(circle(T,1));

// El segmento
filldraw(M -- A -- arc(T,A,B,CW) -- cycle, gray);
