//---------------------------------------------------------------
// Fichero:  semicirculo2.asy
// Objetivo: Representar otro semicírculo
// Fecha:    J.1.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// El centro de la circunferencia
pair T=(0,0);

// Extremos del diámetro
pair A=(Cos(20),Sin(20)), B=(Cos(200),Sin(200));

// La circunferencia
draw(circle(T,1));

// El semicírculo
filldraw(T -- A -- arc((0,0),A,B,CW) -- cycle, gray);

// El centro
dot(T,3bp+black);
