//---------------------------------------------------------------
// Fichero:  propiedadinscrito.asy
// Objetivo: Representar la propiedad del ángulo inscrito
// Fecha:    V.2.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,3.8cm);

// Grosor de las líneas
defaultpen(1);

// El centro de la circunferencia
pair T=(0,0);

// Puntos de la circunferencia
pair V=(Cos(230),Sin(230)), A=(Cos(85),Sin(85)), B=(Cos(-60),Sin(-60));

// Las marcas de los ángulos
markangle("$\beta$",radius=4mm,B,V,A,1bp+blue+squarecap);
markangle("$\alpha$",radius=4mm,B,T,A,1bp+blue+squarecap);

// La circunferencia
draw(circle(T,1));

// Los lados de los ańgulos
draw(V -- A+0.1*(A-V));
draw(V -- B+0.1*(B-V));
draw(T -- 1.2*A);
draw(T -- 1.2*B);

// Los puntos
dot(T,3bp+red);
dot(V,3bp+red);
dot(Label("Q",black), A, NW, 3bp+red);
dot(Label("R",black), B, 2*S+0.5*W, 3bp+red);
