//---------------------------------------------------------------
// Fichero:  propiedadrecto.asy
// Objetivo: Representar la propiedad del ángulo inscrito recto
// Fecha:    V.2.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,3.8cm);

// Grosor de las líneas
defaultpen(1);

// El centro de la circunferencia
pair T=(0,0);

// Puntos de la circunferencia
pair V=(Cos(65),Sin(65)), A=(-1,0), B=(1,0);

// Las marcas de los ángulos
markangle("$\delta$",radius=4mm,A,V,B,1bp+blue+squarecap);
markangle("$\gamma$",radius=2mm,A,T,B,1bp+blue+squarecap);

// La circunferencia
draw(circle(T,1));

// Los lados de los ańgulos
draw(V -- A+0.1*(A-V));
draw(V -- B+0.1*(B-V));
draw(T -- 1.2*A);
draw(T -- 1.2*B);

// Los puntos
dot(T,3bp+red);
dot(V,3bp+red);
dot(Label("C",black), A, NW, 3bp+red);
dot(Label("D",black), B, NE, 3bp+red);
