//---------------------------------------------------------------
// Fichero:  arco.asy
// Objetivo: Representar un arco y sus datos
// Fecha:    D.4.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Para los caracteres no ASCII
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Los ángulos que definen los puntos de la circunferencia
int Ini=20, Fin=140;

// El centro y dos puntos de la circunferencia
pair T=(0,0), A=(Cos(Ini),Sin(Ini)), B=(Cos(Fin),Sin(Fin));

// El ángulo
markangle("Ángulo", radius=6mm, A, T, B, 1bp+deepgreen);

// La circunferencia
draw(circle(T,1));

// El arco
draw(arc(T, 1, Ini, Fin), 2bp+blue);

// Los puntos
dot(T, 3bp+black);
dot(A, 3bp+black);
dot(B, 3bp+black);

// Los radios
draw(A -- T -- B);

// Los textos
real Separacion=0.12;
label(rotate(Ini)*"Radio", (T+A)/2+Separacion*(A.y,-A.x), deepgreen);
label(rotate(180+Fin)*"Radio", (T+B)/2-Separacion*(B.y,-B.x), deepgreen);
