//---------------------------------------------------------------
// Fichero:  simbolos.asy
// Objetivo: Representar un sector y sus datos con símbolos
// Fecha:    D.4.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Para los caracteres no ASCII
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los ángulos que definen los puntos de la circunferencia
real Ini=-50, Fin=60, Med=(Ini+Fin)/2;

// El centro y dos puntos de la circunferencia
pair T=(0,0), A=(Cos(Ini),Sin(Ini)), B=(Cos(Fin),Sin(Fin));

// El sector
fill(T -- A -- arc(T,A,B) -- cycle, lightgray);

// El ángulo
markangle("$\alpha$", radius=4mm, A, T, B, 1bp+black);

// La circunferencia
draw(circle(T,1));

// Los puntos
dot(T, 3bp+black);
dot(A, 3bp+black);
dot(B, 3bp+black);

// Los radios
draw(A -- T -- B);

// Los textos
real Separacion=0.12;
label("A", (Cos(Med),Sin(Med)), 2*W, black);
label("$r$", (T+A)/2+Separacion*(A.y,-A.x), black);
label("$r$", (T+B)/2-Separacion*(B.y,-B.x), black);
