//---------------------------------------------------------------
// Fichero:  trapeciorectangulo1.asy
// Objetivo: Ejercicio sobre trapecio rectángulo
// Fecha:    L.7.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(80,0), C=(38,40), D=(0,40);

// La altura
markrightangle(B, A, D, 0.5bp+gray);
markrightangle(A, D, C, 0.5bp+gray);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(C,D), (C+D)/2, N, blue);
label(Dist(D,A), (D+A)/2, W, blue);
