//---------------------------------------------------------------
// Fichero:  trapecioisosceles2.asy
// Objetivo: Ejercicio sobre trapecio isósceles
// Fecha:    M.8.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para StickIntervalMarker()
import markers;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(-87,0), B=(87,0), C=(55,126), D=(-55,126);

// La altura
pair P=(-8,126), Q=(-8,0);
draw(P -- Q, heavygray);
markrightangle(D, P, Q, 0.5bp+gray);
markrightangle(A, Q, P, 0.5bp+gray);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Las marcas
marker FormExt = StickIntervalMarker(i=1, n=2, angle=0, size=3mm,
                                    space=1mm, p=blue);
draw(B -- C, FormExt);
draw(D -- A, FormExt);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(C,D), (C+D)/2, N, blue);
label(Dist(P,Q), (P+Q)/2, E, blue);
