//---------------------------------------------------------------
// Fichero:  solucion4.asy
// Objetivo: Representar la solución dell problema 4a
// Fecha:    X.9.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 14, Ymin = 0, Ymax = 8, Extra = 0.25;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(10pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los vértices
pair A=(0,6), B=(8,8), C=(14,6), D=(8,0);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle, 2bp+deepgreen);

// Los puntos
dot("A", A, 1.5*N+E, 4bp+black);
dot("B", B, N, 4bp+black);
dot("C", C, E, 4bp+black);
dot("D", D, N, 4bp+black);

// Los puntos medios
pair Q=(A+B)/2, R=(B+C)/2, S=(C+D)/2, T=(D+A)/2;

// El paralelogramo
pen Punteado = linetype(new real[] {2,2});
draw(Q -- R -- S -- T -- cycle, 2bp+deepgreen+Punteado);

// Los puntos
dot("Q", Q, NW, 4bp+black);
dot("R", R, NE, 4bp+black);
dot("S", S, SE, 4bp+black);
dot("T", T, SW, 4bp+black);
