//---------------------------------------------------------------
// Fichero:  angulos.asy
// Objetivo: Representar los ángulos de un paralelogramo
// Fecha:    M.25.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,0), C=(8,3), D=(2,3);

// Los ángulos
pen FormAng=fontsize(9pt)+blue;
pen FormArc=0.5bp+blue;
markangle(Label("$\hat{\textup{A}}$",FormAng),n=2,radius=4mm,B,A,D,FormArc);
markangle(Label("$\hat{\textup{C}}$",FormAng),n=2,radius=4mm,D,C,B,FormArc);
markangle(Label("$\hat{\textup{B}}$",FormAng),n=1,radius=2mm,C,B,A,FormArc);
markangle(Label("$\hat{\textup{D}}$",FormAng),n=1,radius=2mm,A,D,C,FormArc);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Los vértices
dot("A", A, SW, 3bp+black);
dot("B", B, SE, 3bp+black);
dot("C", C, NE, 3bp+black);
dot("D", D, NW, 3bp+black);

