//---------------------------------------------------------------
// Fichero:  rombo.asy
// Objetivo: Representar un rombo
// Fecha:    X.26.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,-3), B=(6,0), C=(0,3), D=(-6,0);

// El centro
pair M=(A+C)/2;

// Las diagonales
pen Punteado = linetype(new real[] {2,2});
draw(A -- C, Punteado+blue);
draw(B -- D, Punteado+blue);

// Los ángulos rectos
markrightangle(D, M, A, 2mm, 0.5bp+gray);
markrightangle(D, M, C, 0.5bp+gray);
markrightangle(C, M, B, 2mm, 0.5bp+gray);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Los puntos
dot("A", A, S, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, N, 3bp+black);
dot("D", D, W, 3bp+black);
dot("M", M, SE, 3bp+black);

// Las marcas
marker FormExt = StickIntervalMarker(i=1, n=2, angle=180, size=2mm,
                                    space=0.75mm, p=blue);
draw(A -- B, FormExt);
draw(B -- C, FormExt);
draw(C -- D, FormExt);
draw(D -- A, FormExt);
