//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Mostrar el enunciado 1
// Fecha:    M.1.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(34,0), C=(25,12), D=(4,12);

// La altura
pair P=D+0.3*(C-D);
pair Q=extension(A, B, P, P+Perpendicular(A,B));
draw(P -- Q, heavygray);
markrightangle(D, P, Q, 0.5bp+gray);
markrightangle(A, Q, P, 0.5bp+gray);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(C,D), (C+D)/2, N, blue);
label(Dist(B,C), (B+C)/2, NE, blue);
label(Dist(D,A), (D+A)/2, W, blue);
label(Dist(P,Q), (P+Q)/2, E, blue);
