//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Mostrar el enunciado 1
// Fecha:    J.3.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(60,0), C=(32,45), D=(0,45);

// La altura
pair Q=(32,0);
pen Punteado = linetype(new real[] {2,2});
draw(C -- Q, heavygray+Punteado);
markrightangle(B, A, D, 0.5bp+gray);
markrightangle(A, D, C, 0.5bp+gray);
markrightangle(B, Q, C, 0.5bp+gray);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(C,D), (C+D)/2, N, blue);
label("$x$", (B+C)/2, NE, blue);
label(Dist(D,A), (D+A)/2, W, blue);

// Una flecha
draw((62,22) -- (77,22), 0.5mm+deepgreen,Arrow(size=2.5mm));

// El triángulo
transform t=shift(64,0);
pair Q1=t*Q, B1=t*B, C1=t*C;
markrightangle(B1, Q1, C1, 0.5bp+gray);
draw(Q1 -- B1 -- C1 -- cycle);
label(Dist(Q1,B1), (Q1+B1)/2, S, blue);
label(Dist(Q1,C1), (Q1+C1)/2, W, blue);
label("$x$", (B1+C1)/2, NE, blue);
