//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Mostrar el enunciado 2
// Fecha:    J.3.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(92,0), C=(44,55), D=(0,55);

// La altura
pair Q=(44,0);
pen Punteado = linetype(new real[] {2,2});
draw(C -- Q, heavygray+Punteado);
markrightangle(B, A, D, 0.5bp+gray);
markrightangle(A, D, C, 0.5bp+gray);
markrightangle(B, Q, C, 0.5bp+gray);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(B,C), (B+C)/2, NE, blue);
label(Dist(C,D), (C+D)/2, N, blue);
label("$x$", (D+A)/2, W, blue);

// Una flecha
//label("$\Longrightarrow$", (105,27), deepgreen);
draw((95,27) -- (112,27), 0.5mm+deepgreen,Arrow(size=2.5mm));

// El triángulo
transform t=shift(85,0);
pair Q1=t*Q, B1=t*B, C1=t*C;
markrightangle(B1, Q1, C1, 0.5bp+gray);
draw(Q1 -- B1 -- C1 -- cycle);
label(Dist(Q1,B1), (Q1+B1)/2, S, blue);
label("$x$", (Q1+C1)/2, W, blue);
label(Dist(B1,C1), (B1+C1)/2, NE, blue);
