//---------------------------------------------------------------
// Fichero:  trapecioisosceles.asy
// Objetivo: Representar un trapecio isósceles
// Fecha:    J.12.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(-3,0), B=(3,0), C=(1.5,2), D=(-1.5,2);

// El eje
pen Punteado = linetype(new real[] {2,2});
draw((0,-0.5) -- (0,2.5), blue+Punteado);
label("$r$", (0,0.5), E, blue);

// Los ángulos
pen FormAng=fontsize(6pt)+blue;
pen FormArc=0.5bp+blue;
markangle(Label("$\hat{\textup{A}}$",FormAng),n=1,radius=2mm,B,A,D,FormArc);
markangle(Label("$\hat{\textup{B}}$",FormAng),n=1,radius=2mm,C,B,A,FormArc);
markangle(Label("$\hat{\textup{C}}$",FormAng),n=2,radius=1.5mm,D,C,B,FormArc);
markangle(Label("$\hat{\textup{D}}$",FormAng),n=2,radius=1.5mm,A,D,C,FormArc);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Los puntos
dot("A", A, SW, 3bp+black);
dot("B", B, SE, 3bp+black);
dot("C", C, NE, 3bp+black);
dot("D", D, NW, 3bp+black);
dot((0,0), 3bp+black);
dot((0,2), 3bp+black);

// Las marcas
marker FormExt = StickIntervalMarker(i=1, n=2, angle=180, size=2mm,
                                    space=0.75mm, p=blue);
draw(B -- C, FormExt);
draw(D -- A, FormExt);
