//---------------------------------------------------------------
// Fichero:  enunciado16.asy
// Objetivo: Representar el enunciado 16
// Fecha:    L.14.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(4,0), B=(1,1), C=(0,4), D=(-1,1), E=(-4,0),
     F=(-1,-1), G=(0,-4), H=(1,-1);

// Los ángulos
markangle("$\alpha$", radius=4mm, A, B, C, 0.5bp+blue);
markangle("$\alpha$", radius=4mm, C, D, E, 0.5bp+blue);
markangle("$\alpha$", radius=4mm, E, F, G, 0.5bp+blue);
markangle("$\alpha$", radius=4mm, G, H, A, 0.5bp+blue);
markangle(Ang(B,A,H,0), radius=8mm, B, A, H, 0.5bp+blue);
markangle(Ang(D,C,B,0), radius=8mm, D, C, B, 0.5bp+blue);
markangle(Ang(F,E,D,1), radius=8mm, F, E, D, 0.5bp+blue);
markangle(Ang(H,G,F,0), radius=8mm, H, G, F, 0.5bp+blue);

// El polígono
draw(A -- B -- C -- D -- E -- F -- G -- H -- cycle);
