//---------------------------------------------------------------
// Fichero:  enunciado4.asy
// Objetivo: Enunciado 4
// Fecha:    X.23.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
int Xmin = -1, Xmax = 7, Ymin = -3, Ymax = 3;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.5bp+gray));

// Grosor de las líneas
defaultpen(1);

// Marcamos en gris todos los puntos de coordenadas enteras
for ( int i=Xmin ; i<=Xmax ; ++i )
    {
    for ( int j=Ymin ; j<=Ymax ; ++j )
        { dot((i,j), 3bp+gray);}
    }

// Los vértices
pair V[]={(0,-1), (4,-3), (7,0), (4,3), (0,1), (-1,3), (-1,-3)};

// El polígono
guide Poligono;
for (int i=0; i<V.length; ++i)
    { Poligono = Poligono -- V[i]; }
  Poligono = Poligono -- cycle;
draw(Poligono);

// Los vértices
for ( int i=0 ; i<V.length ; ++i )
    { dot(V[i], 3bp+black); }
