//---------------------------------------------------------------
// Fichero:  enunciado04.asy
// Objetivo: Enunciado 4
// Fecha:    X.16.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Definición de los vértices
pair A=(73,0), B=(28,28), C=(0,73), D=(-28,28), E=(-73,0),
     F=(-28,-28), G=(0,-73), H=(28,-28);

// Línea auxiliares
draw(B -- D, gray);

// El polígono
draw(A -- B -- C -- D -- E -- F -- G -- H -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, NE, blue);
label(Dist(B,D), (B+D)/2, S, blue);
