//---------------------------------------------------------------
// Fichero:  enunciado05.asy
// Objetivo: Enunciado 5
// Fecha:    X.16.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Los vértices
pair A=(15,0), B=(20,12), C=(-20,12), D=(-15,0), E1=(-22,-24), F=(22,-24);

// Puntos auxiliares
pair Q=(B+C)/2, R=(A+D)/2;

// Líneas auxiliares
draw(A -- D, gray);
draw(Q -- R, gray);

// Ángulos rectos
markrightangle(Q, R, D, 2mm, gray);
markrightangle(C, Q, R, 2mm, gray);

// El polígono
draw(A -- B -- C -- D -- E1 -- F -- cycle);

// Las medidas
label(Dist(B,C), Q, N, blue);
label(Dist(E1,F), (E1+F)/2, S, blue);
label(Dist(A,D), R, S, blue);
label(Dist(A,F), (A+F)/2, E, blue);
label(Dist(Q,R), (Q+R)/2, E, blue);
