//---------------------------------------------------------------
// Fichero:  enunciado08.asy
// Objetivo: Enunciado 8
// Fecha:    J.17.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para StickIntervalMarker()
import markers;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Los vértices
pair A=(0,0), B=(54,0), C=(54,4), D=(22,64), E1=(22,4), F=(11,64), G=(0,4);

// Líneas auxiliares
draw(C -- E1, gray);

// Ángulos rectos
markrightangle(D, E1, C, 4mm, gray);

// El polígono
draw(A -- B -- C -- D -- E1 -- F -- G -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(B,C), (B+C)/2, E, blue);
label(Dist(C,D), (C+D)/2, E, blue);
label(Dist(C,E1), (C+E1)/2, N, blue);

// Las marcas
marker Formato = StickIntervalMarker(i=1, n=2, angle=0, size=2mm,
                                    space=1mm, p=blue);
draw(E1 -- F, Formato);
draw(G -- F, Formato);
