//---------------------------------------------------------------
// Fichero:  hexagonos.asy
// Objetivo: Representar los tres hexágonos
// Fecha:    M.28.3.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Función que dibuja lados y apotemas de un hexágono
void DibujaHexagono(path H)
    {
    for ( int i=0 ; i<3 ; ++i )
        {
        // Las apotemas
        pen Apotema=0.75bp+mediumblue;
        draw(((point(H,i)+point(H,i+1))/2)--((point(H,i+3)+point(H,i+4))/2),
             Apotema);
        // Los lados
        pen Lado=1.5bp+mediumred;
        draw(point(H,i)--point(H,i+1), Lado);
        draw(point(H,i+3)--point(H,i+4), Lado);
        }
    // El centro
    dot((point(H,0)+point(H,3))/2,3bp+black);
    }

// El hexágono de la izquierda
path H1=polygon(6);

// El hexágono de la derecha, arriba
path H2=shift(1.5,1*sqrt(3)/2)*H1;

// El hexágono de la derecha, abajo
path H3=shift(1.5,-1*sqrt(3)/2)*H1;

// Dibujamos los hexágonos
DibujaHexagono(H1);
DibujaHexagono(H2);
DibujaHexagono(H3);
