//---------------------------------------------------------------
// Fichero:  sombrero.asy
// Objetivo: Representar el sombrero
// Fecha:    L.27.3.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// El hexágono de la izquierda
path H1=polygon(6);

// El hexágono de la derecha, arriba
path H2=shift(1.5,1*sqrt(3)/2)*H1;

// El hexágono de la derecha, abajo
path H3=shift(1.5,-1*sqrt(3)/2)*H1;

// Los 13 vértices del sombrero
pair V[];
V[0] = (point(H1,2)+point(H1,3))/2;
V[1] = (point(H1,0)+point(H1,3))/2;
V[2] = (point(H1,4)+point(H1,5))/2;
V[3] = point(H1,5);
V[4] = point(H1,0);
V[5] = (point(H1,0)+point(H1,1))/2;
V[6] = (point(H3,0)+point(H3,3))/2;
V[7] = (point(H3,1)+point(H3,2))/2;
V[8] = point(H3,2);
V[9] = (point(H3,2)+point(H3,3))/2;
V[10] = (point(H2,0)+point(H2,3))/2;
V[11] = (point(H2,3)+point(H2,4))/2;
V[12] = point(H1,2);

// Construimos y dibujamos el sombrero
guide Sombrero;
for ( int i=0 ; i<13 ; ++i )
    { Sombrero = Sombrero -- V [i]; }
Sombrero = Sombrero -- cycle;
draw(Sombrero, 2.5bp+black);

// Los nombres de los vértices
string Nombre="ABCDEFGHIJKLM";

// Las posiciones de los nombres de los vértices
pair Pos[]={NW,SE,W,SW,SE,N,S,E,NE,SW,E,N,SE};

// Ponemos nombres a los vértices
pen Tipo=Helvetica(series="b",shape="n");
for ( int i=0 ; i<13 ; ++i )
  {
  label(substr(Nombre,i,1),V[i],Pos[i],Tipo+fontsize(8pt)+blue);
  dot(V[i],2bp+white);
  }
