//---------------------------------------------------------------
// Fichero:  convexo1.asy
// Objetivo: Representar un polígono convexo
// Fecha:    D.13.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo EPS
settings.outformat="eps";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair V[]={(0,0), (9,-1), (13,7), (-1,6)};
V.cyclic=true;

// Definición de puntos interiores
pair I[]={(1,1), (4,4), (8,1), (11,6.5)};

// Las líneas interiores
for (int i=0; i<I.length/2; ++i)
    { draw(I[2*i] -- I[2*i+1], heavygreen); }

// Los puntos interiores
for (int i=0; i<I.length; ++i)
    { dot(I[i], 3bp+blue); }

// Los ángulos
for (int i=0; i<V.length; ++i)
    { markangle(radius=5bp, V[i+1], V[i], V[i-1], 10bp+heavygreen); }

// El polígono
guide Poligono;
for (int i=0; i<V.length; ++i)
    { Poligono = Poligono -- V[i]; }
  Poligono = Poligono -- cycle;
draw(Poligono);
