//---------------------------------------------------------------
// Fichero:  convexo3.asy
// Objetivo: Representar un polígono convexo
// Fecha:    D.13.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo EPS
settings.outformat="eps";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// El polígono
path Regular=polygon(12);
guide Camino;
for (int i=0; i<12; ++i)
    {
    if ( i<6 ) { Camino = Camino -- point(Regular,i)+(3,0.3); }
    else       { Camino = Camino -- point(Regular,i); }
    }
path Poligono=Camino -- cycle;

// Definición de los vértices
pair V[];
for (int i=0; i<length(Poligono); ++i)
    { V[i] = point(Poligono,i); }
V.cyclic=true;

// Definición de puntos interiores
pair I[]={(-0.5,0), (2,0.8), (3.2,-0.2), (2.5,0.7)};

// Las líneas interiores
for (int i=0; i<I.length/2; ++i)
    { draw(I[2*i] -- I[2*i+1], heavygreen); }

// Los puntos interiores
for (int i=0; i<I.length; ++i)
    { dot(I[i], 3bp+blue); }

// Los ángulos
for (int i=0; i<V.length; ++i)
    { markangle(radius=5bp, V[i+1], V[i], V[i-1], 10bp+heavygreen); }

// El polígono
guide Poligono;
for (int i=0; i<V.length; ++i)
    { Poligono = Poligono -- V[i]; }
  Poligono = Poligono -- cycle;
draw(Poligono);
