//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Ejemplo 1
// Fecha:    D.13.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(2);

// Los vértices
pair A=(-2,0), B=(2,0), C=(3,3), D=(1,2), E=(-1,2), F=(-3,3);

// Los ángulos
markangle(radius=6mm, A, F, E, 3bp+heavygreen);
markangle(radius=6mm, E, A, F, 3bp+heavygreen);
markangle(radius=6mm, F, E, A, 3bp+heavygreen);
markangle(radius=6mm, D, A, E, 3bp+heavyred);
markangle(radius=6mm, A, E, D, 3bp+heavyred);
markangle(radius=6mm, E, D, A, 3bp+heavyred);
markangle(radius=6mm, B, A, D, 3bp+orange);
markangle(radius=6mm, A, D, B, 3bp+orange);
markangle(radius=6mm, D, B, A, 3bp+orange);
markangle(radius=6mm, C, B, D, 3bp+heavymagenta);
markangle(radius=6mm, D, C, B, 3bp+heavymagenta);
markangle(radius=6mm, B, D, C, 3bp+heavymagenta);

// Algunas diagonales
draw(A -- E, 1bp+blue);
draw(A -- D, 1bp+blue);
draw(B -- D, 1bp+blue);

// Los textos
label("T1", (A+F+E)/3, heavygreen);
label("T2", (A+D+E)/3, heavyred);
label("T3", (A+D+B)/3, orange);
label("T4", (C+D+B)/3, heavymagenta);

// El polígono
draw(A -- B -- C -- D -- E -- F -- cycle);
