//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Ejemplo 2
// Fecha:    D.13.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(2);

// Los vértices
pair A=(0,0), B=(4,-3), C=(8,6), D=(2,4), E=(-2,4), F=(-8,6), G=(-4,-3);

// Los ángulos
markangle(radius=6mm, G, F, E, 3bp+heavygreen);
markangle(radius=6mm, F, E, G, 3bp+heavygreen);
markangle(radius=6mm, E, G, F, 3bp+heavygreen);
markangle(radius=6mm, E, A, G, 3bp+lightolive);
markangle(radius=6mm, G, E, A, 3bp+lightolive);
markangle(radius=6mm, A, G, E, 3bp+lightolive);
markangle(radius=6mm, D, A, E, 3bp+heavyred);
markangle(radius=6mm, A, E, D, 3bp+heavyred);
markangle(radius=6mm, E, D, A, 3bp+heavyred);
markangle(radius=6mm, B, A, D, 3bp+orange);
markangle(radius=6mm, A, D, B, 3bp+orange);
markangle(radius=6mm, D, B, A, 3bp+orange);
markangle(radius=6mm, C, B, D, 3bp+heavymagenta);
markangle(radius=6mm, D, C, B, 3bp+heavymagenta);
markangle(radius=6mm, B, D, C, 3bp+heavymagenta);

// Algunas diagonales
draw(A -- E, 1bp+blue);
draw(A -- D, 1bp+blue);
draw(B -- D, 1bp+blue);
draw(E -- G, 1bp+blue);

// Los textos
label("T1", (E+F+G)/3, heavygreen);
label("T2", (A+E+G)/3, lightolive);
label("T3", (A+D+E)/3, heavyred);
label("T4", (A+D+B)/3, orange);
label("T5", (C+D+B)/3, heavymagenta);

// El polígono
draw(A -- B -- C -- D -- E -- F -- G -- cycle);
