//---------------------------------------------------------------
// Fichero:  explicado2.asy
// Objetivo: Explicar el enunciado
// Fecha:    M.15.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Los vértices
pair A=(0,0), B=(21,0), C=(21,3), D=(15,3), E1=(15,5), F=(0,5);

// Puntos auxiliares
pair Q=(15,0), R=(0,3), S1=(21,5);

// Líneas auxiliares
pen Punteado = linetype(new real[] {2,2});
draw(Q -- D, Punteado+gray);
draw(R -- D, Punteado+gray);
draw(C -- S1, Punteado+gray);
draw(E1 -- S1, Punteado+gray);

// El polígono
draw(A -- B -- C -- D -- E1 -- F -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(A,F), (A+F)/2, W, blue);
label(Dist(B,C), (B+C)/2, E, blue);
label(Dist(E1,F), (E1+F)/2, N, blue);

// Los puntos
dot("A", A, SW, 3bp+black);
dot("B", B, SE, 3bp+black);
dot("C", C, E, 3bp+black);
dot("D", D, SW, 3bp+black);
dot("E", E1, NE, 3bp+black);
dot("F", F, NW, 3bp+black);
dot("Q", Q, S, 3bp+black);
dot("R", R, SE, 3bp+black);
dot("S", S1, NE, 3bp+black);
