//---------------------------------------------------------------
// Fichero:  lados5apotema.asy
// Objetivo: Apotema de un polígono regular de 5 lados
// Fecha:    D.20.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,2cm);

// Grosor de las líneas
defaultpen(1);

// El polígono
path Poligono=polygon(5);
draw(Poligono);

// Dos vértices
pair V1=point(Poligono,2);
pair V2=point(Poligono,3);

// Punto medio de un lado
pair M=(V1+V2)/2;

// La apotema
draw((0,0) -- M, 1.5bp+blue);

// Los puntos
dot((0,0), 3bp+black);
dot(M,3bp+black);

