//---------------------------------------------------------------
// Fichero:  paso2.asy
// Objetivo: Paso 2
// Fecha:    S.26.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Función que dibuja las diagonales de un pentágono
void Diagonales(pair V[], pen Lapiz)
    {
    for (int i=0; i<V.length; ++i)
        { draw(V[i] -- V[i+2], Lapiz); }
    }

// Definición del pentágono grande
path PentaG = polygon(5);

// Obtenemos los vértices
pair V[];
for (int i=0; i<5; ++i)
    { V[i] = point(PentaG,i); }
V.cyclic = true;

// Las diagonales del pentágono grande
Diagonales(V, 1bp+gray);

// Los puntos que definen el pentágono pequeño
pair W[];
for (int i=0; i<V.length; ++i)
    { W[i] = intersectionpoint(V[i]-- V[i+2], V[i+1]-- V[i+3]);}
W.cyclic = true;

// Las diagonales del pentágono pequeño
Diagonales(W, 1bp+blue);

// El pentágono grande
draw(PentaG);

// El pentágono pequeño
for (int i=0; i<W.length; ++i)
    { draw(W[i]-- W[i+1], 1bp+blue); }
