//---------------------------------------------------------------
// Fichero:  ejercicio12-sol.asy
// Objetivo: Solución del ejercicio 12
// Fecha:    V.16.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definimos los vértices de un rombo
pair A=(3,0), B=(6,1), C=(3,2), D=(0,1);

// Definimos un rombo
path Rombo = A -- B -- C -- D -- cycle;

// La solución
pair S1 = (B+C)/2;
path Perpendicular = S1 -- shift(2,6)*S1;
pair S2 = intersectionpoint(Perpendicular,shift(3,2)*(A -- D));
draw(S1 -- S2, 2bp+heavygreen+squarecap);

// Señalamos dos rombos
draw(Rombo);
draw(shift(3,2)*Rombo);
