//---------------------------------------------------------------
// Fichero:  enunciado4.asy
// Objetivo: Mostrar el enunciado 4
// Fecha:    D.2.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 31, Ymin = 0, Ymax = 26, Extra = 0.25;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Definición de los vértices
pair A=(2,1), B=(30,5), C=(20,25);

// Las proyecciones
pair QBC=(26,13), QAB=(23,4), QAC=(14,17);

// Las alturas
draw(A -- QBC, 1bp+deepgreen);
draw(B -- QAC, 1bp+deepgreen);
draw(C -- QAB, 1bp+deepgreen);

// El ortocentro
pair H=intersectionpoint(A -- QBC, B -- QAC);
dot(H, 4bp+deepgreen);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot(A, 4bp+deepgreen);
dot(B, 4bp+deepgreen);
dot(C, 4bp+deepgreen);
