//---------------------------------------------------------------
// Fichero:  solucion3.asy
// Objetivo: Representar la solución 3
// Fecha:    X.5.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(4,3);

// Los puntos medios
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;
pair MBC=(B+C)/2;

// Marcamos el ángulo recto
markrightangle(A, B, C, 4mm, gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Las mediatrices
pair U1=MAB+0.5*Perpendicular(A,B);
pair U2=MAB-0.05*Perpendicular(A,B);
draw(U1 -- U2, 1bp+deepgreen);
pair V1=MAC+0.2*Perpendicular(A,C);
pair V2=MAC-0.3*Perpendicular(A,C);
draw(V1 -- V2, 1bp+deepgreen);
pair W1=MBC+0.8*Perpendicular(B,C);
pair W2=MBC-0.1*Perpendicular(B,C);
draw(W1 -- W2, 1bp+deepgreen);

// El circuncentro
pair T=intersectionpoint(U1 -- U2, V1 -- V2);
dot(T, 4bp+deepgreen);
