//---------------------------------------------------------------
// Fichero:  enunciado09.asy
// Objetivo: Representar el enunciado 9
// Fecha:    X.19.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Valores de los catetos
int b=32, c=126;

// Ángulo de rotación de la figura
int Ang=100;

// Los vértices
pair A=(0,0), B=(b,0), C=(0,c);

// Rotamos dos puntos respecto a A
B = rotate(Ang)*B;
C = rotate(Ang)*C;

// Marcamos el ángulo recto
markrightangle(B, A, C, 4mm, gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los datos
label(string(b), (A+B)/2, E);
label(string(c), (A+C)/2, SE);
