//---------------------------------------------------------------
// Fichero:  enunciado10.asy
// Objetivo: Representar el enunciado 10
// Fecha:    X.19.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Valores de la hipotenusa y un cateto
int a=29, b=21;

// Ángulo de rotación de la figura
int Ang=-90;

// Los vértices
pair A=(0,0), B=(b,0), C=(0,sqrt(a*a-b*b));

// Rotamos dos puntos respecto a A
B = rotate(Ang)*B;
C = rotate(Ang)*C;

// Marcamos el ángulo recto
markrightangle(B, A, C, 4mm, gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los datos
label(string(a), (B+C)/2, SE);
label(string(b), (A+B)/2, W);
