//---------------------------------------------------------------
// Fichero:  enunciado07.asy
// Objetivo: Representar el enunciado 7
// Fecha:    V.30.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(8,0), C=(4,7);

// Los ángulos
markangle("$\alpha$", radius=6mm, A, C, B, 0.5bp+blue);
markangle("$62^\circ$", radius=8mm, B, A, C, 0.5bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Las marcas
marker Formato = StickIntervalMarker(i=1, n=3, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(A -- C, Formato);
draw(B -- C, Formato);
